% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_offset_by}
\alias{ExprDT_offset_by}
\alias{(Expr)$dt$offset_by}
\title{Offset By}
\format{
function
}
\arguments{
\item{by}{optional string encoding duration see details.}
}
\value{
Date/Datetime expr
}
\description{
Offset this date by a relative time offset.
This differs from \code{pl$col("foo_datetime_tu") + value_tu} in that it can
take months and leap years into account. Note that only a single minus
sign is allowed in the \code{by} string, as the first character.
}
\details{
The \code{by} are created with the the following string language:
\itemize{
\item 1ns # 1 nanosecond
\item 1us # 1 microsecond
\item 1ms # 1 millisecond
\item 1s  # 1 second
\item 1m  # 1 minute
\item 1h  # 1 hour
\item 1d  # 1 day
\item 1w  # 1 calendar week
\item 1mo # 1 calendar month
\item 1y  # 1 calendar year
\item 1i  # 1 index count
}

These strings can be combined:
\itemize{
\item 3d12h4m25s # 3 days, 12 hours, 4 minutes, and 25 seconds
}
}
\examples{
df = pl$DataFrame(
  dates = pl$date_range(
    as.Date("2000-1-1"),
    as.Date("2005-1-1"),
    "1y",
    lazy = FALSE
  )
)
df$select(
  pl$col("dates")$dt$offset_by("1y")$alias("date_plus_1y"),
  pl$col("dates")$dt$offset_by("-1y2mo")$alias("date_min")
)
}
\keyword{ExprDT}
