% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispersion_class.R, R/count_method.R, R/dispersion_methods.R, R/freq_method.R, R/trim_method.R
\docType{class}
\name{dispersion-class}
\alias{count,dispersion-method}
\alias{dispersion-class}
\alias{freq}
\alias{freq,dispersion-method}
\alias{show,dispersion-method}
\alias{t,dispersion-method}
\alias{trim,dispersion-method}
\title{dispersion class}
\usage{
\S4method{count}{dispersion}(.Object)

\S4method{t}{dispersion}(x)

\S4method{show}{dispersion}(object)

\S4method{freq}{dispersion}(.Object)

\S4method{trim}{dispersion}(object, drop = NULL, merge = list(old = c(), new
  = c()))
}
\arguments{
\item{.Object}{a dispersion object}

\item{x}{a dispersion object}

\item{object}{a crosstab object to be adjusted}

\item{drop}{defaults to NULL, or a character vector giving columns to be dropped}

\item{merge}{a list giving columns to be merged or exactly one string with a regex (see examples)}
}
\value{
a modified crosstab object
}
\description{
class to organize results from dispersion analysis

Drop unwanted columns in a dispersion object, and merge columns by either explicitly stating the columns,
or providing a regex. If merge$old is length 1, it is assumed that a regex is provided
}
\section{Slots}{

\describe{
\item{\code{call}}{call that generated this object}

\item{\code{count}}{Object of class \code{"character"} the call that generated the object}

\item{\code{freq}}{Object of class \code{"character"} the partition the analysis is based on}

\item{\code{dim}}{dimensions of the object}

\item{\code{query}}{the query / the queries that were used}

\item{\code{sizes}}{Object of class \code{"numeric"} the size of the partition}
}}

