% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\docType{methods}
\name{context}
\alias{context}
\alias{context}
\alias{as.matrix,context_bundle-method}
\alias{context,partition-method}
\alias{context,character-method}
\alias{context,partition_bundle-method}
\alias{context,cooccurrences-method}
\title{Analyze context of a node word.}
\usage{
context(.Object, ...)

\S4method{context}{partition}(.Object, query, cqp = is.cqp,
  left = getOption("polmineR.left"), right = getOption("polmineR.right"),
  p_attribute = getOption("polmineR.p_attribute"), boundary = NULL,
  stoplist = NULL, positivelist = NULL, regex = FALSE, count = TRUE,
  mc = getOption("polmineR.mc"), verbose = TRUE, progress = TRUE, ...)

\S4method{context}{character}(.Object, query, cqp = is.cqp,
  p_attribute = getOption("polmineR.p_attribute"), boundary = NULL,
  left = getOption("polmineR.left"), right = getOption("polmineR.right"),
  stoplist = NULL, positivelist = NULL, regex = FALSE, count = TRUE,
  mc = getOption("polmineR.mc"), verbose = TRUE, progress = TRUE, ...)

\S4method{context}{partition_bundle}(.Object, query, p_attribute,
  verbose = TRUE, ...)

\S4method{context}{cooccurrences}(.Object, query, complete = FALSE)
}
\arguments{
\item{.Object}{a partition or a partition_bundle object}

\item{...}{further parameters}

\item{query}{A query, which may by a character vector or a CQP query.}

\item{cqp}{defaults to is.cqp-function, or provide TRUE/FALSE}

\item{left}{Number of tokens to the left of the query match.}

\item{right}{Number of tokens to the right of the query match.}

\item{p_attribute}{The p-attribute of the query.}

\item{boundary}{If provided, a length-one character vector specifying a
s-attribute. It will be checked that corpus positions do not extend beyond
the region defined by the s-attribute.}

\item{stoplist}{Exclude match for query if stopword(s) is/are are present in
context. See positivelist for further explanation.}

\item{positivelist}{character vector or numeric/integer vector: include a query hit
only if token in positivelist is present. If positivelist is a character
vector, it may include regular expressions (see parameter regex)}

\item{regex}{logical, defaults to FALSE - whether stoplist and/or positivelist are
regular expressions}

\item{count}{logical}

\item{mc}{whether to use multicore; if NULL (default), the function will get
the value from the options}

\item{verbose}{report progress, defaults to TRUE}

\item{progress}{logical, whether to show progress bar}

\item{complete}{enhance completely}
}
\value{
depending on whether a partition or a partition_bundle serves as
  input, the return will be a context object, or a \code{context_bundle} object
}
\description{
Retrieve the word context of a token, optionally checking for boundaries of a XML
region.
}
\details{
For formulating the query, CPQ syntax may be used (see
examples). Statistical tests available are log-likelihood, t-test, pmi.
}
\examples{
use("polmineR")
p <- partition("GERMAPARLMINI", interjection = "speech")
y <- context(p, query = "Integration", p_attribute = "word")
y <- context(p, query = "Integration", p_attribute = "word", positivelist = "Bildung")
y <- context(
  p, query = "Integration", p_attribute = "word",
  positivelist = c("[aA]rbeit.*", "Ausbildung"), regex = TRUE
)
}
\author{
Andreas Blaette
}
