% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_bundle.R
\docType{methods}
\name{partition_bundle}
\alias{partition_bundle}
\alias{partition_bundle,partition-method}
\alias{partition_bundle,character-method}
\alias{partition_bundle,context-method}
\alias{partition_bundle,partition_bundle-method}
\title{Generate bundle of partitions.}
\usage{
partition_bundle(.Object, ...)

\S4method{partition_bundle}{partition}(.Object, s_attribute, values = NULL,
  prefix = "", mc = getOption("polmineR.mc"), verbose = TRUE,
  progress = FALSE, type = get_type(.Object), ...)

\S4method{partition_bundle}{character}(.Object, s_attribute, values = NULL,
  prefix = "", mc = getOption("polmineR.mc"), verbose = TRUE,
  progress = FALSE, xml = "flat", type = get_type(.Object), ...)

\S4method{partition_bundle}{context}(.Object, node = TRUE)

\S4method{partition_bundle}{partition_bundle}(.Object, s_attribute,
  prefix = character(), progress = TRUE, mc = getOption("polmineR.mc"))
}
\arguments{
\item{.Object}{A \code{partition}, a length-one \code{character} vector supplying a CWB corpus, or a \code{partition_bundle}}

\item{...}{parameters to be passed into partition-method (see respective documentation)}

\item{s_attribute}{The s-attribute to vary}

\item{values}{Values the s-attribute provided shall assume.}

\item{prefix}{A character vector that will be attached as a prefix to partition names.}

\item{mc}{Logical, whether to use multicore parallelization.}

\item{verbose}{Logical, whether to provide progress information.}

\item{progress}{Logical, whether to show progress bar.}

\item{type}{The type of \code{partition} to generate.}

\item{xml}{logical}

\item{node}{A logical value, whether to include the node (i.e. query matches) in the region matrix
generated when creating a \code{partition} from a \code{context}-object.}
}
\value{
S4 class \code{partition_bundle}, with list of partition objects in slot 'objects'
}
\description{
Use \code{partition_bundle} to create a \code{partition_bundle} object, which
combines a set of \code{partition} objects.
}
\details{
Applying the \code{partition_bundle}-method to a \code{partition_bundle}-object will iterate
through the \code{partition} objects in the \code{object}-slot in the \code{partition_bundle}, and apply
\code{partition_bundle} on each \code{partition}, splitting it up by the s-attribute provided by the 
argument \code{s_attribute}. The return value is a \code{partition_bundle}, the names of which will be
the names of the incoming \code{partition_bundle} concatenated with the s-attribute values used for splitting.
The argument \code{prefix} can be used to achieve a more descriptive name.
}
\examples{
use("polmineR")
bt2009 <- partition("GERMAPARLMINI", date = "2009-.*", regex = TRUE)
pb <- partition_bundle(bt2009, s_attribute = "date", progress = TRUE, p_attribute = "word")
dtm <- as.DocumentTermMatrix(pb, col = "count")
summary(pb)
pb <- partition_bundle("GERMAPARLMINI", s_attribute = "date")
# split up objects in partition_bundle by using partition_bundle-method
use("polmineR")
pb <- partition_bundle("GERMAPARLMINI", s_attribute = "date")
pb2 <- partition_bundle(pb, s_attribute = "speaker", progress = FALSE)

summary(pb2)
}
\seealso{
\code{\link{partition}} and \code{\link{bundle}}
}
\author{
Andreas Blaette
}
