% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\docType{methods}
\name{size}
\alias{size}
\alias{size,slice-method}
\alias{size,corpus-method}
\alias{size,character-method}
\alias{size,partition-method}
\alias{size,DocumentTermMatrix-method}
\alias{size,TermDocumentMatrix-method}
\alias{size,features-method}
\alias{size,remote_corpus-method}
\alias{size,remote_partition-method}
\title{Get Number of Tokens.}
\usage{
size(x, ...)

\S4method{size}{corpus}(x, s_attribute = NULL, verbose = TRUE, ...)

\S4method{size}{character}(x, s_attribute = NULL, verbose = TRUE, ...)

\S4method{size}{partition}(x, s_attribute = NULL, ...)

\S4method{size}{DocumentTermMatrix}(x)

\S4method{size}{TermDocumentMatrix}(x)

\S4method{size}{features}(x)

\S4method{size}{remote_corpus}(x)

\S4method{size}{remote_partition}(x)
}
\arguments{
\item{x}{An object to get size(s) for.}

\item{...}{Further arguments (used only for backwards compatibility).}

\item{s_attribute}{A \code{character} vector with s-attributes (one or more).}

\item{verbose}{A \code{logical} value, whether to output messages.}
}
\value{
An \code{integer} vector if s_attribute is \code{NULL}, a \code{data.table} otherwise.
}
\description{
The method will get the number of tokens in a corpus or partition,
or the dispersion across one or more s-attributes.
}
\details{
One or more s-attributes can be provided to get the dispersion of
tokens across one or more dimensions. Two or more s-attributes
can lead to reasonable results only if the corpus XML is flat.

The \code{size}-method for \code{features} objects will return a
  named list with the size of the corpus of interest ("coi"), i.e. the number
  of tokens in the window, and the reference corpus ("ref"), i.e. the number
  of tokens that are not matched by the query and that are outside the
  window.
}
\examples{
use("polmineR")

# for corpus object
corpus("REUTERS") \%>\% size()
corpus("REUTERS") \%>\% size(s_attribute = "id")
corpus("GERMAPARLMINI") \%>\% size(s_attribute = c("date", "party"))

# for corpus specified by ID
size("GERMAPARLMINI")
size("GERMAPARLMINI", s_attribute = "date")
size("GERMAPARLMINI", s_attribute = c("date", "party"))

# for partition object
P <- partition("GERMAPARLMINI", date = "2009-11-11")
size(P, s_attribute = "speaker")
size(P, s_attribute = "party")
size(P, s_attribute = c("speaker", "party"))

# for subcorpus
sc <- corpus("GERMAPARLMINI") \%>\% subset(date == "2009-11-11")
size(sc, s_attribute = "speaker")
size(sc, s_attribute = "party")
size(sc, s_attribute = c("speaker", "party"))
}
\seealso{
See \code{\link{dispersion}}-method for counts of hits. The \code{\link{hits}}
method calls the \code{size}-method to get sizes of subcorpora.
}
