% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{merge_marker_assignments}
\alias{merge_marker_assignments}
\title{Merge marker assignments}
\usage{
merge_marker_assignments(dosage_matrix, target_parent = "P1",
  other_parent = "P2", LG_hom_stack, SN_linked_markers, ploidy,
  LG_number = 5, log = NULL)
}
\arguments{
\item{dosage_matrix}{A dosage \code{matrix}.}

\item{target_parent}{Character string specifying target parent.}

\item{other_parent}{Character string specifying other parent.}

\item{LG_hom_stack}{data.frame specifying 1.0 marker assignments to linkage groups and homologues.}

\item{SN_linked_markers}{a list of marker assignment objects}

\item{ploidy}{Ploidy level of plant species.}

\item{LG_number}{Number of linkage groups (chromosomes).}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
Returns a matrix with marker assignments. Number of linkages of 1.0 markers are artificial.
}
\description{
\code{merge_marker_assignments} Merges 1.0 backbone object with marker assignment objects
}
\examples{
data("screened_data3", "LGHomDf_P1_1", "P1_SxS_Assigned", "P1_DxN_Assigned")
merged_assignment<-merge_marker_assignments(screened_data3, target_parent="P1",
                         other_parent="P2",
                         LG_hom_stack=LGHomDf_P1_1,
                         SN_linked_markers=list(P1_SxS_Assigned, P1_DxN_Assigned),
                         ploidy=4,
                         LG_number=5)
}
