% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{spline_IBD}
\alias{spline_IBD}
\title{Fit splines to IBD probabilities}
\usage{
spline_IBD(IBD_list, gap, ncores = 1, log = NULL)
}
\arguments{
\item{IBD_list}{List of IBD probabilities}

\item{gap}{The size (in centiMorgans) of the gap between splined positions}

\item{ncores}{Number of cores to use, by default 1 only. Works both for Windows and UNIX (using \code{doParallel}).
Use \code{parallel::detectCores()} to find out how many cores you have available. Note that with large datasets, using multiple cores
will use large amounts of memory (RAM). Single-core or e.g. 2-core evaluations, although slower, is less memory-intensive.}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}
}
\value{
Returns a list of similar format as IBD_list, with a splined \code{IBD_array} in place of the original \code{IBD_array}
}
\description{
Fits splines to IBD probabilities at a grid of positions at user-defined spacing.
}
\examples{
data("IBD_4x")
IBD_4x.spl <- spline_IBD(IBD_list = IBD_4x, gap = 1)
}
