\name{B-splines}
\alias{bspline.basis}
\alias{periodic.bspline.basis}
\title{B-spline bases}
\description{
  These functions generate B-spline basis functions.
  \code{bspline.basis} gives a basis of spline functions.
  \code{periodic.bspline.basis} gives a basis of periodic spline functions.
}
\usage{
bspline.basis(x, nbasis, degree = 3, deriv = 0, names = NULL)
periodic.bspline.basis(x, nbasis, degree = 3, period = 1, deriv = 0,
                       names = NULL)
}
\arguments{
  \item{x}{Vector at which the spline functions are to be evaluated.}
  \item{nbasis}{The number of basis functions to return.}
  \item{degree}{Degree of requested B-splines.}
  \item{period}{The period of the requested periodic B-splines.}
  \item{deriv}{The order of the derivative required.}
  \item{names}{
    optional; the names to be given to the basis functions.
    These will be the column-names of the matrix returned.
    If the names are specified as a format string (e.g., "basis\%d"), \code{\link{sprintf}} will be used to generate the names from the column number.
    If a single non-format string is specified, the names will be generated by \code{\link{paste}}-ing \code{name} to the column number.
    One can also specify each column name explicitly by giving a length-\code{nbasis} string vector.
    By default, no column-names are given.
  }
}
\value{
  \item{bspline.basis}{
    Returns a matrix with \code{length(x)} rows and \code{nbasis} columns.
    Each column contains the values one of the spline basis functions.
    If \code{deriv>0}, the derivatives of the corresponding spline basis functions are returned.
  }
  \item{periodic.bspline.basis}{
    Returns a matrix with \code{length(x)} rows and \code{nbasis} columns.
    The basis functions returned are periodic with period \code{period}.
    If \code{deriv>0}, the derivatives of the corresponding spline basis functions are returned.
  }
}
\section{C API}{
  Access to the underlying C routines is available:
  see the header file \href{https://github.com/kingaa/pomp/blob/master/inst/include/pomp.h}{\file{pomp.h}} for definition and documentation of the C API.
  At an \R prompt, execute \preformatted{file.show(system.file("include/pomp.h",package="pomp"))} to view this file.
}
\author{Aaron A. King}
\examples{
x <- seq(0,2,by=0.01)
y <- bspline.basis(x,degree=3,nbasis=9,names="basis")
matplot(x,y,type='l',ylim=c(0,1.1))
lines(x,apply(y,1,sum),lwd=2)

x <- seq(-1,2,by=0.01)
y <- periodic.bspline.basis(x,nbasis=5,names="spline\%d")
matplot(x,y,type='l')
}
\keyword{smooth}
