% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_sumstats.R
\name{exclusive}
\alias{exclusive}
\title{Compute the fraction of exclusive sites}
\usage{
exclusive(minor, total, nPops)
}
\arguments{
\item{minor}{is a matrix with the number of minor-allele reads. Each row of
the matrix is a different population and each column a different site.}

\item{total}{is a matrix with the total coverage. Each row of the matrix is a
different population and each column a different site.}

\item{nPops}{is an integer indicating the total number of populations.}
}
\value{
a numeric vector with two entries when \code{nPops} is equal to 2 or
with five entries when \code{nPops} is set to 4.
}
\description{
This function will compute the fraction of sites showing an exclusive
polymorphism to a given population.
}
\details{
More precisely, we define exclusive polymorphisms as sites that are
segregating in only one of the populations. To clarify, we define segregating
sites as sites where the number of minor-allele reads of a given population
at a given site are not equal to zero or to the total coverage of that
population. We then check if those segregating sites are also segregating in
the other population.

For models with two populations, this function compares the two present-day
populations. For models with four populations, this function performs a
pairwise comparison of the populations at each of the locations. For the
models with four populations, we also assess the fraction of sites that are
segregating only in one population and not in the other three.
}
\keyword{internal}
