% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rc2}
\alias{rc2}
\title{Data frame with an example of observed data}
\format{
a data frame with 5000 rows and 59 columns. Each of the columns
corresponds to :

\describe{

\item{col1}{reference chromosome (contig).}

\item{col2}{reference position.}

\item{col3}{reference character.}

\item{col4}{number of alleles found in all populations.}

\item{col5}{allele characters in all populations (sorted by counts in all
populations).}

\item{col6}{sum of deletions in all populations (should be zero, if not the
position may not be reliable).}

\item{col7}{SNP type: \code{[pop, rc, rc|pop]}; pop: a SNP within or
between the populations; rc: a SNP between the reference sequence character
and the consensus of at least one populaton; rc|pop: both.}

\item{col8}{most frequent allele in all populations \code{[12345..]}.}

\item{col9}{second most frequent allele in all populations
\code{[12345..]}.}

\item{col10 - col34}{frequencies of the most frequent allele (major) in the
form "allele-count/coverage.}

\item{col35 - col59}{frequencies of the second most frequent allele (minor)
in the form "allele-count/coverage".} }
}
\source{
Hernán E. Morales et al., Genomic architecture of parallel ecological
divergence: Beyond a single environmental contrast. Sci. Adv.5,
eaav9963(2019). DOI:10.1126/sciadv.aav9963
}
\usage{
rc2
}
\description{
Data frame with data in the \verb{_rc} format for 25 populations Each
row of the data frame is a different site. The first 9 columns contain
general information about the site, while the remaining contain the number
of reads observed at that site for each of the 25 populations.
}
\keyword{datasets}
