% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.pooldata.R
\docType{class}
\name{pooldata-class}
\alias{pooldata-class}
\alias{pooldata}
\title{An S4 class to represent a Pool-Seq data set.}
\description{
An S4 class to represent a Pool-Seq data set.
}
\section{Slots}{

\describe{
\item{\code{npools}}{The number of pools}

\item{\code{nsnp}}{The number of SNPs}

\item{\code{refallele.readcount}}{A matrix (nsnp rows and npools columns) with read count data for the reference allele}

\item{\code{readcoverage}}{A matrix (nsnp rows and Npools columns) with overall read coverage}

\item{\code{snp.info}}{A matrix (nsnp rows and 4 columns) detailing for each SNP, the chromosome (or scaffold), the position, allele 1 and allele 2}

\item{\code{poolsizes}}{A vector of length npools with the corresponding haploid pool sizes}

\item{\code{poolnames}}{A vector of length npools with the corresponding haploid pool names}
}}

\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}}, \code{\link{genobaypass2pooldata}} and \code{\link{genoselestim2pooldata}}
}
