% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{extract_nonvscan_counts}
\alias{extract_nonvscan_counts}
\alias{.extract_nonvscan_counts}
\title{extract_nonvscan_counts}
\usage{
.extract_nonvscan_counts(vcf_data, nb_all, ad_idx, min_rc)
}
\arguments{
\item{vcf_data}{a matrix of String containing count information}

\item{nb_all}{a vector containing the number of alleles for the different markers}

\item{ad_idx}{the index of the FORMAT AD field}

\item{min_rc}{Minimal allowed read count per base (same as min.rc option in \code{\link{vcf2pooldata}})}
}
\value{
A numeric matrix of read count with nsnp rows and 2*npools+6 columns.
The first npools columns consist of read count for the reference allele,
columns npools+1 to 2*npools consist of read coverage. The last 6 columns correspond to 
the index of the two most frequent alleles (idx_all1 and idx_all2) and their count (cnt_all1 and cnt_all2);
the min_rc filtering criterion and count of variant (cnt_bases) other than two first most frequent. The min_rc crit is
set to -1 for polymorphisms with more than 2 alleles and with the third most frequent alleles having 
more than min_rc count
}
\description{
Extract counts from vcf produced by other caller than VarScan (e.g., bcftools, FreeBayes, GATK)
}
\details{
Extract VarScan counts and return read counts for the reference and alternate allele
}
\examples{
.extract_nonvscan_counts(rbind(c("0/0:20,0","1/1:1,18"),c("0/2:12,1,15","1/1:27,1,0")),c(2,3),2,0)
.extract_nonvscan_counts(rbind(c("0/0:20,0","1/1:1,18"),c("0/2:12,1,15","1/1:27,1,0")),c(2,3),2,2)
}
