% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{robust_values}
\alias{robust_values}
\title{Convert values to numeric robustly}
\usage{
robust_values(num.values, force = FALSE, messages = TRUE)
}
\arguments{
\item{num.values}{values to convert to numeric}

\item{force}{logical; if \code{TRUE}, returns a vector of values where values that cannot be interpreted as numeric are
set to \code{NA}; if \code{FALSE}, returns the original vector and gives a warning if any value cannot be interpreted as
numeric.}

\item{messages}{logical; if \code{TRUE}, returns a message of what was done with the \code{num.values}}
}
\value{
A numeric vector.
}
\description{
Brute force solution for ensuring a variable is numeric by 
coercing a variable of any type first to factor and then to numeric
}
\note{
Returns \code{NULL} if given \code{num.values} is \code{NULL}.
}
\examples{
## this works
values <- c("1", "3", "5")
values <- robust_values(values)

## this works
values <- c("1", "3", "5", NA)
values <- robust_values(values)

## this returns originals and throws warnings
values <- c("1", "3", "5", "a")
suppressWarnings(
  values <- robust_values(values)
)


## this forces "a" to NA and works otherwise; throws warning about NAs
values <- c("1", "3", "5", "a")
suppressWarnings(
  values <- robust_values(values, force=TRUE)
)

}
\author{
Joonas Miettinen
}
