% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitLexisDT.R
\name{splitLexisDT}
\alias{splitLexisDT}
\title{Split case-level observations}
\usage{
splitLexisDT(lex, breaks, timeScale, merge = TRUE, drop = TRUE)
}
\arguments{
\item{lex}{a Lexis object, split or not}

\item{breaks}{a vector of \code{[a,b)} breaks to split \code{data} by}

\item{timeScale}{a character string; name of the time scale to split by}

\item{merge}{logical; if \code{TRUE}, retains all variables 
from the original data - i.e. original variables are
repeated for all the rows by original subject}

\item{drop}{logical; if \code{TRUE}, drops all resulting rows 
after expansion that reside outside the time window
defined by the given breaks}
}
\value{
A \code{data.table} or \code{data.frame} 
(depending on \code{options("popEpi.datatable")}; see \code{?popEpi}) 
object expanded to accommodate split observations.
}
\description{
Split a \code{Lexis} object along one time scale
(as \code{\link[Epi]{splitLexis}}) with speed
}
\details{
\code{splitLexisDT} is in essence a \pkg{data.table} version of
\code{splitLexis} or \code{survSplit} for splitting along a single
time scale. It requires a Lexis object as input, which may have already
been split along some time scale.

Unlike \code{splitLexis}, \code{splitLexisDT} drops observed time outside
the roof and floor of \code{breaks} by default - with \code{drop = FALSE}
the functions have identical behaviour.

The \code{Lexis} time scale variables can be of any arbitrary 
format, e.g. \code{Date},
fractional years (see \code{\link[Epi]{cal.yr}}) and \code{\link{get.yrs}},
or other. However, using \code{date} variables (from package \pkg{date})
are not recommended, as \code{date} variables are always stored as integers,
whereas \code{Date} variables (see \code{?as.Date}) are typically stored
in double ("numeric") format. This allows for breaking days into fractions
as well, when using e.g. hypothetical years of 365.25 days.
}
\examples{
library(Epi)
data("sire", package = "popEpi")
x <- Lexis(data=sire[1000:1100, ], 
           entry = list(fot=0, per=get.yrs(dg_date), age=dg_age), 
           exit=list(per=get.yrs(ex_date)), exit.status=status)
BL <- list(fot=seq(0, 5, by = 3/12), per=c(2008, 2013))

x2 <- splitMulti(x, breaks = BL, drop = FALSE)

x3 <- splitLexisDT(x, breaks = BL$fot, timeScale = "fot", drop = FALSE)
x3 <- splitLexisDT(x3, breaks = BL$per, timeScale = "per", drop = FALSE)

x4 <- splitLexis(x,  breaks = BL$fot, time.scale = "fot")
x4 <- splitLexis(x4, breaks = BL$per, time.scale = "per")
## all produce identical results

## using Date variables
x <- Lexis(data=sire[1000:1100, ], 
           entry = list(fot=0, per=dg_date, age=dg_date-bi_date), 
           exit=list(per=ex_date), exit.status=status)
BL <- list(fot = 0:5*365.25, per = as.Date(c("2008-01-01", "2013-01-01")))

x2 <- splitMulti(x, breaks = BL, drop = FALSE)

x3 <- splitLexisDT(x, breaks = BL$fot, timeScale = "fot", drop = FALSE)
x3 <- splitLexisDT(x3, breaks = BL$per, timeScale = "per", drop = FALSE)

## splitLexis may not work when using Dates
}
\seealso{
Other splitting functions: \code{\link{lexpand}},
  \code{\link{splitMulti}}
}
\author{
Joonas Miettinen
}
