% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_logistic.R
\name{growth_logistic}
\alias{growth_logistic}
\title{Logistic growth}
\usage{
growth_logistic(pivot_values, pivot_years, upper, lower, t)
}
\arguments{
\item{pivot_values}{numeric. Reference values to estimate, like TFR for two specific years.}

\item{pivot_years}{numeric. Reference years to estimate for both values in \code{pivot_values}.}

\item{upper}{numeric. Upper asymptotic value.}

\item{lower}{numeric. Lower asymptotic value.}

\item{t}{numeric. Year to get logistic value.}
}
\value{
\code{growth_logistic} returns the logistic estimation for specified year.
}
\description{
Given two pivots and limits, estimates the growth assuming a logistic behavior.
}
\examples{

# Given TFR values 3.32 and 2.85 for the years 1986 and 1991, respectively,
# estimate the TFR in 1987 assuming 1.5 as lower limit and 8 as upper limit.

growth_logistic(pivot_values = c(3.32, 2.85), pivot_years = c(1986, 1991),
upper = 8, lower=1.5, t=1987)

}
\references{
\insertRef{growth_exp}{popstudy}
}
\seealso{
\code{\link{growth_exp}}, \code{\link{growth_linear}}
}
\author{
Cesar Gamboa-Sanabria
}
