% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_estimate.R
\name{pp_estimate}
\alias{pp_estimate}
\title{Areal Interpolation of Population Data}
\usage{
pp_estimate(
  target,
  source,
  sid,
  spop,
  volume = NULL,
  ancillary = NULL,
  point = FALSE,
  method
)
}
\arguments{
\item{target}{An object of class \code{sf} that is used to interpolate data
to. Usually, target may include polygon features representing building units}

\item{source}{An object of class \code{sf} including data to be interpolated.
Source may be a set of coarse polygon features such as city blocks or
census tracts}

\item{sid}{Source identification number}

\item{spop}{Source population values to be interpolated}

\item{volume}{Target feature volume information (height or number of floors).
Required when \code{method=vwi}}

\item{ancillary}{ancillary information}

\item{point}{Whether to return point geometries (FALSE by default)}

\item{method}{Two methods provided: \code{awi} (areal weighting interpolation)
and \code{vwi} (volume weighting interpolation). \code{awi} proportionately
interpolates the population values based on areal weights calculated
by the area of intersection between the source and target zones. \code{vwi}
proportionately interpolates the population values based on areal weights
calculated by the area of intersection between the source and target zones
multipled by the volume information (height or number of floors).}
}
\value{
An object of class \code{sf} including estimated population
    counts for target features using either \code{awi} or \code{vwi}
    methods. The estimated population counts are stored in a new column called
    pp_est.
}
\description{
Areal Interpolation of Population Data
}
\examples{
# read lib data
data('src')
data('trg')

# areal weighted interpolation - awi
pp_estimate(trg, src, sid = sid, spop = pop,
    method = awi)

# areal weighted interpolation - awi using point geometries
pp_estimate(trg, src, sid = sid, spop = pop,
    method = awi, point = TRUE)

# volume weighted interpolation - vwi
pp_estimate(trg, src, sid = sid, spop = pop,
    method = vwi, volume = floors)

# volume weighted interpolation - vwi using point geometries
pp_estimate(trg, src, sid = sid, spop = pop,
    method = vwi, volume = floors, point = TRUE)

}
