% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_individual_rodents.R
\name{summarize_individual_rodents}
\alias{summarize_individual_rodents}
\alias{summarise_individual_rodents}
\title{Return cleaned Portal rodent individual data}
\usage{
summarize_individual_rodents(
  path = get_default_data_path(),
  clean = TRUE,
  type = "Rodents",
  length = "all",
  unknowns = FALSE,
  time = "period",
  fillweight = FALSE,
  min_plots = 1,
  min_traps = 1,
  download_if_missing = TRUE,
  quiet = FALSE
)

summarise_individual_rodents(
  path = get_default_data_path(),
  clean = TRUE,
  type = "Rodents",
  length = "all",
  unknowns = FALSE,
  time = "period",
  fillweight = FALSE,
  min_plots = 1,
  min_traps = 1,
  download_if_missing = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{path}{either the file path that contains the PortalData folder or
"repo", which then pulls data from the PortalData GitHub repository}

\item{clean}{logical, load only QA/QC rodent data (TRUE) or all data (FALSE)}

\item{type}{specify subset of species; either all "Rodents" or only
"Granivores"}

\item{length}{specify subset of plots; use "All" plots or only "Longterm"
plots (to be deprecated)}

\item{unknowns}{either removes all individuals not identified to species
(unknowns = FALSE) or sums them in an additional column (unknowns = TRUE)}

\item{time}{specify the format of the time index in the output, either
"period" (sequential Portal surveys), "newmoon" (lunar cycle numbering),
"date" (calendar date), or "all" (for all time indices)}

\item{fillweight}{specify whether to fill in unknown weights with other
records from that individual or species, where possible}

\item{min_plots}{minimum number of plots within a period for an
observation to be included}

\item{min_traps}{minimum number of traps for a plot to be included}

\item{download_if_missing}{if the specified file path doesn't have the
PortalData folder, then download it}

\item{quiet}{logical, whether to run without producing messages}
}
\value{
a data.frame
}
\description{
This function cleans and subsets the data based on a number
  of arguments. It returns stake number and individual level data.
}
