% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsMinimal.R
\name{IsMinimal}
\alias{IsMinimal}
\title{Checking minimality.}
\usage{
IsMinimal(poset, element)
}
\arguments{
\item{poset}{An object of S4-class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{element}{A character string (the name of the input element).}
}
\value{
A boolean value.
}
\description{
Checks whether the input element is minimal in the input poset.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

chk <- IsMinimal(pos, "a")

}
