% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_estim.R
\name{poso_simu_pop}
\alias{poso_simu_pop}
\title{Estimate the prior distribution of population parameters}
\usage{
poso_simu_pop(
  dat = NULL,
  prior_model = NULL,
  n_simul = 1000,
  return_model = TRUE
)
}
\arguments{
\item{dat}{Dataframe. An individual subject dataset following the
structure of NONMEM/rxode2 event records.}

\item{prior_model}{A \code{posologyr} prior population pharmacokinetics
model, a list of six objects.}

\item{n_simul}{An integer, the number of simulations to be run. For \code{n_simul =0}, all ETAs are set to 0.}

\item{return_model}{A boolean. Returns a rxode2 model using the simulated
ETAs if set to \code{TRUE}.}
}
\value{
If \code{return_model} is set to \code{FALSE}, a list of one element: a
dataframe \verb{$eta} of the individual values of ETA.
If \code{return_model} is set to \code{TRUE}, a list of the dataframe of the
individual values of ETA, \verb{$model} an rxode2 model using the estimated ETAs,
\verb{$event} the \code{data.table} used to solve the returned rxode2 model.
}
\description{
Estimates the prior distribution of population parameters by Monte Carlo
simulations
}
\examples{
# model
mod_run001 <- function() {
  ini({
    THETA_Cl <- 4.0
    THETA_Vc <- 70.0
    THETA_Ka <- 1.0
    ETA_Cl ~ 0.2
    ETA_Vc ~ 0.2
    ETA_Ka ~ 0.2
    prop.sd <- sqrt(0.05)
  })
  model({
    TVCl <- THETA_Cl
    TVVc <- THETA_Vc
    TVKa <- THETA_Ka

    Cl <- TVCl*exp(ETA_Cl)
    Vc <- TVVc*exp(ETA_Vc)
    Ka <- TVKa*exp(ETA_Ka)

    K20 <- Cl/Vc
    Cc <- centr/Vc

    d/dt(depot) = -Ka*depot
    d/dt(centr) = Ka*depot - K20*centr
    Cc ~ prop(prop.sd)
  })
}
# df_patient01: event table for Patient01, following a 30 minutes intravenous
# infusion
df_patient01 <- data.frame(ID=1,
                        TIME=c(0.0,1.0,14.0),
                        DV=c(NA,25.0,5.5),
                        AMT=c(2000,0,0),
                        EVID=c(1,0,0),
                        DUR=c(0.5,NA,NA))
# estimate the prior distribution of population parameters
poso_simu_pop(dat=df_patient01,prior_model=mod_run001,n_simul=100)

}
