% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.powdRafps}
\alias{plot.powdRafps}
\title{Plotting elements of a powdRafps object}
\usage{
\method{plot}{powdRafps}(x, wavelength, interactive, ...)
}
\arguments{
\item{x}{a powdRfps object}

\item{wavelength}{One of "Cu", "Co" or a custom numeric value defining the wavelength
(in Angstroms). Used to compute d-spacings.When "Cu" or "Co" are supplied, wavelengths
of 1.54056 or 1.78897 are used, respectively.}

\item{interactive}{logical. If TRUE then the output will be an interactive
ggplotly object. If FALSE then the output will be a ggplot object.}

\item{...}{other arguments}
}
\description{
\code{plot.powdRafps} is designed to provide easy, adaptable plots
of full pattern summation outputs produced from \code{\link{afps}}.
}
\details{
The only mandatory argument is \code{x}, which must be a powdRlib object.
When seeking to inspect the results from full pattern summation, interactive
plots are particularly useful and can be specified with the \code{interactive}
argument.
}
\examples{
#Load the minerals library
data(minerals)

# Load the soils data
data(soils)

\dontrun{
afps_sand <-  afps(lib = minerals,
                   smpl = soils$sandstone,
                   std = "QUA.1",
                   amorphous = "ORG",
                   align = 0.2,
                   lod = 0.1)

plot(afps_sand, wavelength = "Cu")
plot(afps_sand, wavelength = "Cu", interactive = TRUE)

}
}
