% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSampleSize.R
\name{computeSampleSize}
\alias{computeSampleSize}
\title{sample size estimation}
\usage{
computeSampleSize(n, X, Y, A, alpha, beta,
nperm, Nsim, seed, test = "R2",...)
}
\arguments{
\item{n}{vector of sample sizes to consider}

\item{X}{data matrix where columns represent the \eqn{p} variables and
rows the \eqn{n} observations.}

\item{Y}{data matrix where columns represent the two classes and
rows the \eqn{n} observations.}

\item{A}{number of score components}

\item{alpha}{level of type I error. Default 0.05}

\item{beta}{level of type II error. Default 0.2.}

\item{nperm}{number of permutations. Default 100.}

\item{Nsim}{number of simulations. Default 100.}

\item{seed}{seed value}

\item{test}{type of test, one of \code{c("score", "mcc", "R2")}.
Default to @R2.}

\item{...}{Futher parameters.}
}
\value{
Returns a dataframe that contains the estimated power for each
sample size and number of components considered
}
\description{
Compute optimal sample size calculation
}
\examples{
\donttest{
datas <- simulatePilotData(nvar = 10, clus.size = c(5,5),m = 6,nvar_rel = 5,A = 2)
out <- computeSampleSize(X = datas$X, Y = datas$Y, A = 2, n = 20)
}
}
\references{
Andreella, A., Finos, L., Scarpa, B. and Stocchero, M. "Towards a power analysis for PLS-based methods" 	arXiv:2403.10289 stat.ME.
}
\author{
Angela Andreella
}
