% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-decision.R
\name{plot_decision_threshold_contour}
\alias{plot_decision_threshold_contour}
\title{Plot Decision Threshold Contour (Multi-Effect Grid Friendly)}
\usage{
plot_decision_threshold_contour(
  power_results,
  metric = c("direction", "threshold", "rope"),
  p_star_grid = seq(0.5, 0.99, by = 0.01),
  effect_var = NULL,
  facet_by = NULL,
  effect_value = NULL,
  effect_weights = NULL,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results}{brms_inla_power list (or two-stage, etc.)}

\item{metric}{Which metric: "direction", "threshold", "rope"}

\item{p_star_grid}{Numeric vector of decision thresholds (default: 0.5 to 0.99 by 0.01)}

\item{effect_var}{Name of effect grid column for y-axis (default: first detected grid column)}

\item{facet_by}{Optional effect grid column(s) to facet by}

\item{effect_value}{Optional value(s) to filter for effect_var, or named list for multi-filter}

\item{effect_weights}{Optional weights for aggregation (named by effect_var values)}

\item{title, subtitle}{Optional plot labels.}
}
\value{
ggplot2 object.
}
\description{
Shows assurance as a function of decision threshold p* and one effect grid column, optionally faceted.
}
