% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{sim_formula_compare}
\alias{sim_formula_compare}
\title{Compare multiple simulation formulas}
\usage{
sim_formula_compare(...)
}
\arguments{
\item{...}{Named formulas that should be compared, see \emph{Examples}.}
}
\value{
Object with class \code{plcp_compare_sim_formula}
}
\description{
This functions allows comparing multiple models fit to the same data set
during simulation.
}
\examples{

# Formulas can be a named character
# uses the defaults 'sim_formula()'
f <- sim_formula_compare("m0" = "y ~ time * treatment + (1 | subject)",
                         "m1" = "y ~ time * treatment + (1 + time | subject)")

# Can also use sim_formula()
f0 <- sim_formula("y ~ time * treatment + (1 | subject)")
f1 <- sim_formula("y ~ time * treatment + (1 + time | subject)")
f <- sim_formula_compare("m0" = f0, "m1" = f1)

}
\seealso{
\code{\link{sim_formula}}
}
