% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc_votes.R
\name{ppc_votes}
\alias{ppc_votes}
\title{Votes}
\usage{
ppc_votes(chamber = c("both", "house", "senate"), api_key = NULL,
  raw = FALSE)
}
\arguments{
\item{chamber}{Specify the chamber of Congress typically "house" or "senate";
sometimes "both" or "joint"}

\item{api_key}{The actual API key string provided by ProPublica.}

\item{raw}{Logical indicating whether to return the raw response object. The
default (FALSE) parses the content and returns a tibble data frame.}
}
\value{
A data frame of congressional votes information
}
\description{
Get Recent Votes
}
\details{
By tradition, the Speaker of the House votes at his or her
discretion, and typically does not vote. When the Speaker does vote, the
official source data from the Clerk of the House includes that information,
but when the Speaker does not vote, the data provided by the Clerk does not
include that information. In those cases, ProPublica adds a record showing
the Speaker as not voting and increases the total number of lawmakers not
voting by one (both in the Speaker's party and overall). In those cases,
the not voting totals provided by the API for House votes will not match
the Clerk's totals.
}
\examples{
\dontrun{
## get votes from only the house
hv <- ppc_votes("house")

## get votes from the house and the senate
hsv <- ppc_votes("both")
}
}
