% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{get_table}
\alias{get_table}
\title{Get PPI table/s based on a specified PPI table/s search output}
\usage{
get_table(region = levels(steer$region),
  country = as.character(steer$country[steer$region \%in\% region]),
  type = as.character(steer$type[steer$country \%in\% country]))
}
\arguments{
\item{region}{Region of the world to search PPI table from. Default is
\code{c("Africa", "Asia", "Eastern Europe and Central Asia",
"Latin America and the Carribean", "Middle East and North Africa")}. Allows
specification of one region or a vector of regions.}

\item{country}{Country to search PPI table from. Default is vector of all
country names from the specified region/s. Allows specification of one
country name or a vector of country names.}

\item{type}{Type of PPI calculation used. Can be one of two options: \code{"sps"}
for the Simple Poverty Scorecard calculation or \code{ipa} for the
International Poverty Alliance calculation. Default is vector of all
calculation types available for the specified country/ies.}
}
\value{
A data frame in \code{tibble} format of corresponding PPI table/s
    matching the search parameters. The data frame is in \code{tidy} format
    and contains the corresponding poverty probability (\code{ppi}) for a
    specific score (\code{score}) for various poverty definitions \code{poverty_definition})
    for the country (\code{country}) and PPI calculation type (\code{type}).
}
\description{
Get PPI table/s based on a specified PPI table/s search output
}
\examples{
#
# Create a tidy format PPI table for Nepal
#
get_table(region = "Asia", country = "Nepal")

}
