% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_decision_rules.R
\name{calc_decision_rules}
\alias{calc_decision_rules}
\title{Calculate a decision rule table for interim monitoring of a pre-specified
design}
\usage{
calc_decision_rules(
  n,
  N,
  theta,
  ppp,
  p0,
  direction = "greater",
  delta = NULL,
  prior = c(0.5, 0.5),
  S = 5000
)
}
\arguments{
\item{n}{matrix containing the total number of patients accrued so far at
each interim look in the standard of care (column 1) and experimental
(column 2) arms for two-sample case; vector of sample size accrued so far
at each interim look for one-sample case. The last value should be equal to
the total sample size at the end of the trial.
If only a single look will be done
at the end of the trial, this can be a vector specifying the total sample
size c(N0, N1) for the two-sample case or an integer specifying the total
sample size N for the one-sample case}

\item{N}{the total planned sample size at the end of the trial, c(N0, N1)
for two-sample case; integer of total planned sample size at end of trial N
for one-sample case}

\item{theta}{The target posterior probability. e.g. Efficacy decision if
P(p1 > p0) > theta for the two-sample case with greater direction.}

\item{ppp}{The target predictive probability. e.g. Stop the trial if the
predictive probability falls below this target.}

\item{p0}{The target value to compare to in the one-sample case. Set to NULL
for the two-sample case.}

\item{direction}{"greater" (default) if interest is in P(p1 > p0) and "less"
if interest is in P(p1 < p0) for two-sample case. For one-sample case,
"greater" if interest is in P(p > p0) and "less" if interest is in P(p < p0).}

\item{delta}{clinically meaningful difference between groups.
Typically 0 for two-sample case. NULL for one-sample case (default).}

\item{prior}{hyperparameters of prior beta distribution.
Beta(0.5, 0.5) is default}

\item{S}{number of samples, default is 5000}
}
\value{
In the one-sample case, returns a tibble with n at each look, r at
each look, and ppp, the associated posterior predictive probability.
Stop the trial at that look if the number of observed responses is <=r.
At the end of the trial, the treatment is considered promising if the number
of observed responses is >r.
In the two-sample case, returns a tibble with n0 and n1, the number
enrolled subjects in the control and experimental arms at each look,
respectively, r0 and r1, the number of possible responses in the control and
experimental arms at each look, respectively, and ppp, the associated
posterior predictive probability. For a given value of r0, stop the trial if
the number of observed responses in the experimental arm is <=r1. At the end
of the trial, the treatment is considered promising if the number of
observed responses in the experimental arm is >r1 for a given r0.
Any NA value in either table represents an
interim look where there is no number of responses that would lead to
stopping the trial.
}
\description{
This function will take the posterior and predictive thresholds
for a pre-specified design with a given null response rate and fixed interim
looks and total sample size, and return the decision rules at each interim
analysis and the end of the trial. Intended for use after selecting an
optimal design using the functions \code{calibrate_thresholds} and
\code{optimize_design}.
}
\examples{
set.seed(123)

# One-sample case
calc_decision_rules(
  n = seq(5, 25, 5), 
  N = 25, 
  theta = 0.86, 
  ppp = 0.2, 
  p0 = 0.1, 
  S = 50
  )

# Two-sample case
calc_decision_rules(
  n = cbind(seq(5, 25, 5), seq(5, 25, 5)), 
  N = c(25, 25),
  theta = 0.86, 
  ppp = 0.2, 
  p0 = NULL, 
  direction = "greater", 
  delta = 0, 
  S = 50
  )

}
