% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{bsnullinteract}
\alias{bsnullinteract}
\title{Compute bootstrapped null interaction prediction rule ensembles}
\usage{
bsnullinteract(object, nsamp = 10, parallel = FALSE,
  penalty.par.val = "lambda.1se", verbose = FALSE)
}
\arguments{
\item{object}{object of class \code{\link{pre}}.}

\item{nsamp}{numeric. Number of bootstrapped null interaction models to be
derived.}

\item{parallel}{logical. Should parallel foreach be used to generate initial
ensemble? Must register parallel beforehand, such as doMC or others.}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{verbose}{logical. should progress be printed to the command line?}
}
\value{
A list of length \code{nsamp} with null interaction models, to be
used as input for \code{\link{interact}}.
}
\description{
\code{bsnullinteract} generates bootstrapped null interaction models,
which can be used to derive a reference distribution of the test statistic
calculated with \code{\link{interact}}.
}
\details{
Computationally intensive.
}
\examples{
\donttest{set.seed(42)
airq.ens <- pre(Ozone ~ ., data=airquality[complete.cases(airquality),])
nullmods <- bsnullinteract(airq.ens)
interact(airq.ens, nullmods = nullmods, col = c("#7FBFF5", "#8CC876"))}
}
\seealso{
\code{\link{pre}}, \code{\link{interact}}
}
