% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpe.R
\name{rTerm}
\alias{rTerm}
\alias{lTerm}
\alias{eTerm}
\title{Wrapper Functions for terms in gpe}
\usage{
rTerm(x)

lTerm(x, lb = -Inf, ub = Inf, scale = 1/0.4)

eTerm(x, scale = 1/0.4)
}
\arguments{
\item{x}{Input symbol.}

\item{lb}{Lower quantile when winsorizing. \code{-Inf} yields no winsorizing in the lower tail.}

\item{ub}{Lower quantile when winsorizing. \code{Inf} yields no winsorizing in the upper tail.}

\item{scale}{Inverse value to time \code{x} by. Usually the standard deviation is used. \code{0.4 / scale} is used as the multiplier as suggested in Friedman & Popescu (2008) and gives each linear term the same a-priori influence as a typical rule.}
}
\value{
\code{x} potentially transformed with additional information provided in the attributes.
}
\description{
Wrapper functions for terms in gpe.
}
\details{
The motivation to use wrappers is to ease getting the different terms as shown in the examples and to simplify the formula passed to \code{\link{cv.glmnet}} in \code{\link{gpe}}. \code{lTerm} potentially rescales and/or winsorizes \code{x} depending on the input. \code{eTerm} potentially rescale \code{x} depending on the input.
}
\examples{
mt <- terms(
~ rTerm(x1 < 0) + rTerm(x2 > 0) + lTerm(x3) + eTerm(x4), 
specials = c("rTerm", "lTerm", "eTerm"))
attr(mt, "specials")
# $rTerm
# [1] 1 2
# 
# $lTerm
# [1] 3
# 
# $eTerm
# [1] 4

}
\references{
Friedman, J. H., & Popescu, B. E. (2008). Predictive learning via rule ensembles. \emph{The Annals of Applied Statistics, 2}(3), 916-954.
}
\seealso{
\code{\link{gpe}}, \code{\link{gpe_trees}} \code{\link{gpe_linear}} \code{\link{gpe_earth}}
}
