% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxicity_generators.R
\docType{class}
\name{hyper_mtdi_lognormal-class}
\alias{hyper_mtdi_lognormal-class}
\alias{hyper_mtdi_lognormal}
\title{Hyperprior for lognormal MTDi distributions}
\description{
This hyperprior generates lognormal MTDi distributions with their
coefficient of variation being drawn from a Rayleigh distribution
with mode parameter \code{CV}. Because the standard deviation of
this distribution is
}
\details{
this implicitly link our uncertainty about \code{CV} to its value.

The medians of the lognormal distributions generated are themselves
drawn from a lognormal distribution with \code{meanlog = log(median_mtd)}
and \code{sdlog = median_sdlog}. Thus, parameter \code{median_sdlog}
represents a proportional uncertainty in \code{median_mtd}.
}
\section{Slots}{

\describe{
\item{\code{CV}}{Coefficient of variation}

\item{\code{median_mtd}}{Median MTDi}

\item{\code{median_sdlog}}{Proportional uncertainty in median MTDi}
}}

