% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precautionary-package.R
\docType{package}
\name{precautionary-package}
\alias{precautionary-package}
\alias{precautionary}
\title{Safety Diagnostics for Dose-Escalation Trial Designs}
\description{
Enhances various R packages that support the design and simulation
of phase 1 dose-escalation trials, adding diagnostics to examine the safety
characteristics of these designs in light of expected inter-individual variation
in pharmacokinetics and pharmacodynamics.
}
\references{
\enumerate{
\item Norris DC. Dose Titration Algorithm Tuning (DTAT) should supersede
\sQuote{the} Maximum Tolerated Dose (MTD) in oncology dose-finding trials.
\emph{F1000Research}. 2017;6:112. \doi{10.12688/f1000research.10624.3}.
\url{https://f1000research.com/articles/6-112/v3}
\item Norris DC. Costing \sQuote{the} MTD. \emph{bioRxiv}. August 2017:150821.
\doi{10.1101/150821}.
\url{https://www.biorxiv.org/content/10.1101/150821v3}
\item Norris DC. Precautionary Coherence Unravels Dose Escalation Designs.
\emph{bioRxiv}. December 2017:240846. \doi{10.1101/240846}.
\url{https://www.biorxiv.org/content/10.1101/240846v1}
\item Norris DC. One-size-fits-all dosing in oncology wastes money, innovation
and lives. \emph{Drug Discov Today}. 2018;23(1):4-6.
\doi{10.1016/j.drudis.2017.11.008}.
\url{https://www.sciencedirect.com/science/article/pii/S1359644617303586}
\item Norris DC. Costing \sQuote{the} MTD ... in 2-D. \emph{bioRxiv}. July 2018:370817.
\doi{10.1101/370817}.
\url{https://www.biorxiv.org/content/10.1101/370817v1}
\item Norris DC. Ethical Review and Methodologic Innovation in Phase 1 Cancer Trials.
\emph{JAMA Pediatrics}. 2019;173(6):609
\doi{10.1001/jamapediatrics.2019.0811}.
\item Norris DC. Comment on Wages et al., Coherence principles in interval-based
dose finding. Pharmaceutical Statistics 2019, DOI: 10.1002/pst.1974.
\emph{Pharmaceutical Statistics}. March 2020.
\doi{10.1002/pst.2016}.
\item Norris DC. Retrospective analysis of a fatal dose-finding trial.
arXiv:2004.12755 [stat.ME]. April 2020.
\url{https://arxiv.org/abs/2004.12755}
}
}
\author{
David C. Norris (\url{https://orcid.org/0000-0001-9593-6343})
}
