% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/limits.r
\name{limits}
\alias{limits}
\alias{precintcon.limits.analysis}
\title{Limits}
\usage{
limits(\dots)
}
\arguments{
\item{\dots}{a set of daily or monthly precipitation series.}
}
\value{
A data.frame containing the following variables:
\itemize{
\item \code{dataset} is the precipitation serie name.
\item \code{max} is the maximum value in the precipitation serie.
\item \code{max.date} is the first date of the maximum precipitation serie.
\item \code{min} is the minimum value in the precipitation serie.
\item \code{min.date} is the first date of the minimum precipitation serie.
}
}
\description{
Calculates the upper and lower limit on a set of daily or monthly
precipitation series.
}
\examples{
##
# Loading the monthly precipitation serie.
data(monthly)

##
# Performing the Concentration Index Analysis
limits(monthly)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{read.data}}
\code{\link{as.daily}}
}
\keyword{limits}
\keyword{precipitation}

