% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pplot.histogram.r
\name{pplot.histogram}
\alias{pplot.histogram}
\alias{precintcon.plot.histogram}
\title{Plot histogram}
\usage{
pplot.histogram(\dots, density = FALSE,
grouped = FALSE, xlab = "Precipitation (mm)",
ylab = "Frequency", legend.title = "Legend",
legend = NULL, fontsize = 10, axis.text.color = "black",
export = FALSE, export.name = "histogram_plot.png",
width = 10, height = 10, units = "cm")
}
\arguments{
\item{density}{the logical value for defining whether the graph should be
plotted with bars or lines. (Default value: FALSE)}

\item{grouped}{the logical value for defining whether the series should
be plotted in the same graph or not. (Default value: FALSE)}

\item{xlab}{the text for the x axis. (Default value: "Precipitation (mm)")}

\item{ylab}{the text for the y axis. (Default value: "Frequency")}

\item{legend.title}{the text for the legend title. (Default value: "Legend")}

\item{legend}{the text vector for the legend items. If NULL the legends will
be equals to the variable names. (Default value: NULL)}

\item{fontsize}{the font size value in pt. (Default value: 10)}

\item{axis.text.color}{the legend colors. (Default value: "black")}

\item{export}{the logical value for defining whether the graph should be
export to a file or not. (Default value: FALSE)}

\item{export.name}{the text for defining the exported file name. It is only
used if export = TRUE. (Default value: "histogram_plot.png")}

\item{width}{the number for defining the exported graph width. It is only
used if export = TRUE. (Default value: 10)}

\item{height}{the number for defining the exported graph height. It is only
used if export = TRUE. (Default value: 10)}

\item{units}{the text for defining the units of the height and width
parameters. It is only used if export = TRUE. (Default value: "cm")}

\item{\dots}{a set of daily or monthly precipitation series.}
}
\description{
Plots the histogram of a precipitation serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Performing the a set of statistical analysis
pplot.histogram(daily)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{read.data}}
}
\keyword{histogram}
\keyword{precipitation}

