% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pplot.pn.r
\name{pplot.pn}
\alias{pplot.pn}
\alias{precintcon.plot.pn}
\title{Plot Percent of Normal}
\usage{
pplot.pn(\dots, interval = 30, scale = "a", xlab = NA, ylab = "PN",
         fontsize = 10, axis.text.color = "black", legend = NULL,
         export = FALSE, export.name = "pn_plot.png", width = 10,
         height = 10, units = "cm")
}
\arguments{
\item{interval}{the number of months applied for calculating the percentage
of normal.}

\item{scale}{the scale used for calculating the percentage of normal,
which should be either "w" for weak (not supported yet),
"m" for month, "s" for season, or "d" for decades.}

\item{xlab}{the text for the x axis. (Default value: NA)}

\item{ylab}{the text for the y axis. (Default value: "PN")}

\item{fontsize}{the font size value in pt. (Default value: 10)}

\item{axis.text.color}{the legend colors. (Default value: "black")}

\item{legend}{the text vector for the legend items. If NULL the legends will
be equals to the variable names. (Default value: NULL)}

\item{export}{the logical value for defining whether the graph should be export
to a file or not. (Default value: FALSE)}

\item{export.name}{the text for defining the exported file name. It is only used
if export = TRUE. (Default value: "pci_plot.png")}

\item{width}{the number for defining the exported graph width. It is only used if
export = TRUE. (Default value: 10)}

\item{height}{the number for defining the exported graph height. It is only used
if export = TRUE. (Default value: 10)}

\item{units}{the text for defining the units of the height and width parameters.
It is only used if export = TRUE. (Default value: "cm")}

\item{\dots}{a set of daily or monthly precipitation serie.}
}
\description{
Plots the Percent of Normal of a precipitation serie.
}
\examples{
##
# Loading the daily precipitation serie.
data(daily)

##
# Performing the a set of statistical analysis
pplot.pn(daily)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{read.data}}
}
\keyword{normal}
\keyword{of}
\keyword{percent}
\keyword{precipitation}

