% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.r
\name{app}
\alias{app}
\title{Amount and Percentage of Precipitation}
\usage{
app(..., percent = 25)
}
\arguments{
\item{percent}{is the percentage of the rainiest days to be considered (default = 25).}

\item{\dots}{a set of daily precipitation series.}
}
\value{
data.frame containing the following variables:
\itemize{
\item \code{dataset} is the dataset name of the precipitation serie;
\item \code{percentage} is the percentage of the rainiest days;
\item \code{absolute} is the absolute amount of precipitation generated by \code{percentage}% of the rainiest days; and
\item \code{relative} is the percentage of precipitation benerated by \code{percentage}% of the rainiest days.
}
}
\description{
It calculates the amount and percentage of precipitation contributed by a such percent of rainiest days.
}
\examples{
##
# Loading the daily precipitation serie
data(daily) 

##
# Calculating amount and percentage of precipitation using different parameters

app(daily)

app(daily, percent = 20)

app(daily, percent = c(10, 15, 20, 25))
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{read.data}}
\code{\link{as.daily}}
\code{\link{ci}}
}

