% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pn.r
\name{pn}
\alias{pn}
\alias{precintcon.pn.analysis}
\title{Percentage of Normal}
\usage{
pn(object, interval = 30, scale = "a")
}
\arguments{
\item{object}{a daily or monthly precipitation serie.}

\item{interval}{the number of months applied for calculating the percentage of 
normal.}

\item{scale}{the scale used for calculating the percentage of normal, 
which should be either "w" for weak (not supported yet), 
"m" for month, "s" for season, or "d" for decades.}
}
\value{
A data.frame (precintcon.pn) containing the following variables:
\itemize{ 
\item \code{year} is the year.
\item \code{month} is the month. It exists only whether scale = "m".
\item \code{pn} is the percentage of normal.
}
}
\description{
Calculates the Percentage of Normal (PN) on a daily or 
monthly precipitation serie.
}
\examples{
##
# Loading the monthly precipitation serie.
data(monthly)

##
# Performing the Percentage of Normal analysis
pn(monthly)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{pplot.pn}}
\code{\link{read.data}}
\code{\link{as.daily}}
\code{\link{as.monthly}}
}
\keyword{normal}
\keyword{of}
\keyword{percent}
\keyword{precipitation}

