% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm2_join_data.R
\name{join_labels}
\alias{join_labels}
\title{Join observed labels of multiple test datasets into a list}
\usage{
join_labels(..., byrow = FALSE, chklen = TRUE)
}
\arguments{
\item{...}{Multiple datasets. They can be vectors, arrays, matrices,
data frames, and lists.}

\item{byrow}{A Boolean value to specify whether row vectors are used
for matrix, data frame, and array.}

\item{chklen}{A Boolean value to specify whether all list items must be
the same lengths.}
}
\value{
The \code{join_labels} function returns a list that
  contains all combined label data.
}
\description{
\code{join_labels} takes observed labels and converts them to a list.
}
\examples{

##################################################
### Add three numeric vectors
###
l1 <- c(1, 0, 1, 1)
l2 <- c(1, 1, 0, 0)
l3 <- c(0, 1, 0, 1)
labels1 <- join_labels(l1, l2, l3)

## Show the list structure
str(labels1)


##################################################
### Add a matrix and a numeric vector
###
a1 <- matrix(rep(c(1, 0), 4), 4, 2)
labels2 <- join_labels(a1, l3)

## Show the list structure
str(labels2)


##################################################
### Use byrow
###
a2 <- matrix(rep(c(1, 0), 4), 2, 4, byrow = TRUE)
labels3 <- join_labels(a2, l3, byrow = TRUE)

## Show the list structure
str(labels3)


##################################################
### Use chklen
###
l4 <- c(-1, 0, -1)
l5 <- c(0, -1)
labels4 <- join_labels(l4, l5, chklen = FALSE)

## Show the list structure
str(labels4)

}
\seealso{
\code{\link{evalmod}} for calculation evaluation measures.
  \code{\link{mmdata}} for formatting input data.
  \code{\link{join_scores}} for formatting scores with multiple datasets.
}

