% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPredict.R
\name{fit2newdata}
\alias{fit2newdata}
\title{Make a new data set for prediction}
\usage{
fit2newdata(fit, predictors, mode = 1, pred.values = NULL,
  modx.values = NULL, mod2.values = NULL, colorn = 3, maxylev = 6)
}
\arguments{
\item{fit}{An object of class "lm", "glm" or "loess"}

\item{predictors}{Names of predictor variables in string}

\item{mode}{A numeric. Useful when the variables are numeric. If 1, c(-1,0,1)*sd + mean is used. If 2, the 14th, 50th, 86th percentile values used. If 3 sequence over a the range of a vector used}

\item{pred.values}{For which values of the predictors should be used? Default is NULL. If NULL, 20 seq_range is used.}

\item{modx.values}{For which values of the moderator should lines be plotted? Default is NULL. If NULL, then the customary +/- 1 standard deviation from the mean as well as the mean itself are used for continuous moderators. If the moderator is a factor variable and modx.values is NULL, each level of the factor is included.}

\item{mod2.values}{For which values of the second moderator should lines be plotted? Default is NULL. If NULL, then the customary +/- 1 standard deviation from the mean as well as the mean itself are used for continuous moderators. If the moderator is a factor variable and modx.values is NULL, each level of the factor is included.}

\item{colorn}{The number of regression lines when the modifier variable(s) are numeric.}

\item{maxylev}{An integer indicating the maximum number of levels of numeric variable be treated as a categorical variable}
}
\description{
Make a new data set for prediction
}
\examples{
fit=lm(mpg~hp*wt*cyl+carb+am,data=mtcars)
fit2newdata(fit,predictors=c("hp","wt","am"))
fit2newdata(fit,predictors=c("hp","wt","cyl"))
fit2newdata(fit,predictors=c("hp"))
fit=loess(mpg~hp*wt*am,data=mtcars)
fit2newdata(fit,predictors=c("hp"))
\donttest{
mtcars$engine=ifelse(mtcars$vs==0,"V-shaped","straight")
fit=lm(mpg~wt*engine,data=mtcars)
fit2newdata(fit,predictors=c("wt","engine"))
fit=lm(mpg~wt*factor(vs),data=mtcars)
fit2newdata(fit,predictors=c("wt","vs"))
fit2newdata(lm(mpg~hp*wt,data=mtcars),predictors=c("hp","wt"),mode=3,colorn=30)
fit=lm(mpg~hp*log(wt),data=mtcars)
fit2newdata(fit,predictors=c("hp","log(wt)"))
}
}
