% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{pressure_interp}
\alias{pressure_interp}
\title{Interpolate pressure data}
\usage{
pressure_interp(pressure_data, interp_to)
}
\arguments{
\item{pressure_data}{List. First item should be a 3D array covering each
timepoint of the measurement. z dimension represents time.}

\item{interp_to}{Integer. Number of frames to interpolate to}
}
\value{
\itemize{
  \item pressure_array. 3D array covering each timepoint of the measurement.
           z dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. Numeric vector with the dimensions of the sensors
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
 }
}
\description{
Resamples pressure data over time. Useful for normalizing to
stance phase, for example
}
\examples{
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
pressure_data <- pressure_interp(pressure_data, interp_to = 101)
}
