## ---- echo=FALSE---------------------------------------------------------
knitr::opts_chunk$set(comment = "#>", collapse = TRUE)
set.seed(1)

## ---- echo=FALSE, message=FALSE------------------------------------------
library(dplyr)
library(purrr)
library(ggplot2)
library(princurve)
data("benchmarks", package = "princurve")

## ----benchmark, eval=FALSE-----------------------------------------------
#  # warning: running this will take ± 2 hours
#  # princurvelegacy can be installed using devtools::install_github("dynverse/princurve@legacy")
#  num_points <- round(10^seq(log10(100), log10(100000), length.out = 25))
#  lambda <- rnorm(max(num_points), 0, .2)
#  x <- cbind(lambda, lambda^2) + rnorm(length(lambda) * 2, 0, .02)
#  
#  benchmarks <- map_df(
#    rev(num_points),
#    function(np) {
#      xsel <- x[seq_len(np),]
#      microbenchmark::microbenchmark(
#        "princurve1.1" = princurvelegacy::principal.curve(xsel),
#        "princurve2.1" = princurve::principal_curve(xsel, approx_points = 100),
#        times = 10L,
#        unit = "ms"
#      ) %>%
#        summary() %>%
#        as_data_frame() %>%
#        mutate(num_points = np)
#    }
#  )

## ----compare, fig.width=8, fig.height=8----------------------------------
ggplot(benchmarks, aes(num_points, median / 1000)) +
  geom_point() +
  geom_line() +
  facet_wrap(~expr, ncol = 1, scales = "free") +
  theme_bw() +
  labs(x = "Number of rows in dataset", y = "Time (s)") +
  scale_colour_brewer(palette = "Set1")

