% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_field.r
\name{gaussian_field}
\alias{gaussian_field}
\title{Generate spatially autocorrelated random field}
\usage{
gaussian_field(r, range, n = 1, mean = 0, variance = 1, nugget = 0,
  coef = c(0, 0), prop = NULL)
}
\arguments{
\item{r}{Raster* object; the template for the random field.}

\item{range}{numeric; the range of the underlying variogram, the distance
beyond which autocorrelation is negligible. This argument defines the
spatial scale of the autocorrelation.}

\item{n}{integer; number of random fields to generate.}

\item{mean}{numeric; mean value of the random field.}

\item{variance}{numeric; the sill of the underlying variogram model, which
can be thought of as the variance of the random field.}

\item{nugget}{numeric; the nugget component of the underlying variogram model}

\item{coef}{numeric vector; if a linear trend in the x and/or y direction is
desired, this a vector with 2 components representing the slopes in the x
and y directions, respectively.}

\item{prop}{numeric value between 0-1; if \code{pct} is supplied, the field
will be reclassified into binary values, where \code{pct} represents the
proportion of ones. Useful for generating presence/absence layers.}
}
\value{
RasterStack
}
\description{
Generate spatially autocorrelated random fields based on a Gaussian process
model. This function outputs a \code{RasterLayer} or \code{RasterStack}
object representing the random field. These fields can be used as
semi-realistic distributions of species or other spatial variables. Building
in spatial autocorrelation ensures that these random fields obey Tobler's
first law of geography: "everything is related to everything else, but near
things are more related than distant things".
}
\examples{
e <- raster::extent(0, 100, 0, 100)
r <- raster::raster(e, nrows = 100, ncols = 100, vals = 1)
gf <- gaussian_field(r, range = 20, n = 4)
raster::plot(gf)

# generate binary rasters with different ranges
gf_5 <- gaussian_field(r, range = 5, n = 1, prop = 0.5)
gf_20 <- gaussian_field(r, range = 20, n = 1, prop = 0.5)
s <- raster::stack(gf_5, gf_20)
raster::plot(s)

# add a linear trend
gf_linear <-gaussian_field(r, range = 20, coef = c(0.05, 0.05))
raster::plot(gf_linear)
}

