% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{prioritizrdata}
\alias{prioritizrdata}
\title{prioritizrdata: Conservation Planning Datasets}
\description{
The \pkg{prioritizrdata} package is a supplemental package that contains
example datasets for conservation planning. It is intended to be used
alongside the
\href{https://CRAN.R-project.org/package=prioritizr}{\pkg{prioritizr} package}---a
package for building and solving systematic conservation prioritization
problems using integer linear programming (ILP) techniques---and provides
little functionality itself.
}
\details{
This package contains the following datasets:

\describe{

\item{\link{tas_data}}{This dataset was obtained from the
\href{https://marxansolutions.org/}{"Introduction to \emph{Marxan}" course}
and was originally part of a larger spatial prioritization performed under
contract to Australia's Department of Environment and Water Resources.
This dataset contains vector-based planning unit data and data for the
spatial distribution of 62 vegetation classes in Tasmania, Australia.
Refer to the \href{https://CRAN.R-project.org/package=prioritizr/vignettes/tasmania.html}{Tasmania vignette in the \pkg{prioritizr} package} for a
worked example with this dataset.}

\item{\link{salt_data}}{This dataset is from an
online \href{https://arcese.forestry.ubc.ca/marxan-tool/}{\emph{Marxan}-based planning tool}
created for the Coastal Douglas-fir Conservation Partnership (CDFCP). It
contains raster-based planning unit data and the data for the spatial
distributions of five key ecological communities in the area. Refer to
the \href{https://CRAN.R-project.org/package=prioritizr/vignettes/saltspring.html}{Salt Spring Island vignette in the \pkg{prioritizr} package} for a
worked example with this dataset.}

}
}
