% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/and.R
\name{and}
\alias{and}
\title{Check for co-existence of two activities}
\usage{
and(activity_a, activity_b)
}
\arguments{
\item{activity_a}{Activity A. A character vector of length one. This should be an activity of the event log supplied to  `check_rule`.}

\item{activity_b}{Activity B. A character vector of length one. This should be an activity of the event log supplied to  `check_rule`.}
}
\description{
The`and` rule checks whether two activities both occur in a case (or are both absent).
If activity A exists, Activity B should also exist, and vice versa.
}
\examples{
library(bupaR)
library(eventdataR)

# Check that if a patients is registered, he's also checked-out, and vice versa.
patients \%>\%
check_rule(and("Registration","Check-out"))

}
\seealso{
Other Declarative Rules: \code{\link{absent}},
  \code{\link{contains_between}},
  \code{\link{contains_exactly}}, \code{\link{contains}},
  \code{\link{ends}}, \code{\link{precedence}},
  \code{\link{responded_existence}},
  \code{\link{response}}, \code{\link{starts}},
  \code{\link{succession}}, \code{\link{xor}}
}
\concept{Declarative Rules}
