% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{conn_create_fd}
\alias{conn_create_fd}
\alias{conn_create_pipepair}
\alias{conn_read_chars}
\alias{conn_read_chars.processx_connection}
\alias{processx_conn_read_chars}
\alias{conn_read_lines}
\alias{conn_read_lines.processx_connection}
\alias{processx_conn_read_lines}
\alias{conn_is_incomplete}
\alias{conn_is_incomplete.processx_connection}
\alias{processx_conn_is_incomplete}
\alias{conn_write}
\alias{conn_write.processx_connection}
\alias{processx_conn_write}
\alias{conn_create_file}
\alias{conn_set_stdout}
\alias{conn_set_stderr}
\alias{conn_get_fileno}
\alias{conn_disable_inheritance}
\alias{close.processx_connection}
\alias{processx_conn_close}
\title{Processx connections}
\usage{
conn_create_fd(fd, encoding = "", close = TRUE)

conn_create_pipepair(encoding = "", nonblocking = c(TRUE, FALSE))

conn_read_chars(con, n = -1)

\method{conn_read_chars}{processx_connection}(con, n = -1)

processx_conn_read_chars(con, n = -1)

conn_read_lines(con, n = -1)

\method{conn_read_lines}{processx_connection}(con, n = -1)

processx_conn_read_lines(con, n = -1)

conn_is_incomplete(con)

\method{conn_is_incomplete}{processx_connection}(con)

processx_conn_is_incomplete(con)

conn_write(con, str, sep = "\\n", encoding = "")

\method{conn_write}{processx_connection}(con, str, sep = "\\n",
  encoding = "")

processx_conn_write(con, str, sep = "\\n", encoding = "")

conn_create_file(filename, read = NULL, write = NULL)

conn_set_stdout(con, drop = TRUE)

conn_set_stderr(con, drop = TRUE)

conn_get_fileno(con)

conn_disable_inheritance()

\method{close}{processx_connection}(con, ...)

processx_conn_close(con, ...)
}
\arguments{
\item{fd}{Integer scalar, a Unix file descriptor.}

\item{encoding}{Encoding of the readable connection when reading.}

\item{close}{Whether to close the OS file descriptor when closing
the connection. Sometimes you want to leave it open, and use it again
in a \code{conn_create_fd} call.
Encoding to re-encode \code{str} into when writing.}

\item{nonblocking}{Whether the writeable and the readable ends of
the pipe should be non-blocking connections.}

\item{con}{Processx connection object.}

\item{n}{Number of characters or lines to read. -1 means all available
characters or lines.}

\item{str}{Character or raw vector to write.}

\item{sep}{Separator to use if \code{str} is a character vector. Ignored if
\code{str} is a raw vector.}

\item{filename}{File name.}

\item{read}{Whether the connection is readable.}

\item{write}{Whethe the connection is writeable.}

\item{drop}{Whether to close the original stdout/stderr, or keep it
open and return a connection to it.}

\item{...}{Extra arguments, for compatibility with the \code{close()}
generic, currently ignored by processx.}
}
\description{
These functions are currently experimental and will change
in the future. Note that processx connections are  \emph{not}
compatible with R's built-in connection system.
}
\details{
\code{conn_create_fd()} creates a connection from a file descriptor.

\code{conn_create_pipepair()} creates a pair of connected connections, the
first one is writeable, the second one is readable.

\code{conn_read_chars()} reads UTF-8 characters from the connections. If the
connection itself is not UTF-8 encoded, it re-encodes it.

\code{conn_read_lines()} reads lines from a connection.

\code{conn_is_incomplete()} returns \code{FALSE} if the connection surely has no
more data.

\code{conn_write()} writes a character or raw vector to the connection.
It might not be able to write all bytes into the connection, in which
case it returns the leftover bytes in a raw vector. Call \code{conn_write()}
again with this raw vector.

\code{conn_create_file()} creates a connection to a file.

\code{conn_set_stdout()} set the standard output of the R process, to the
specified connection.

\code{conn_set_stderr()} set the standard error of the R process, to the
specified connection.

\code{conn_get_fileno()} return the integer file desciptor that belongs to
the connection.

\code{conn_disable_inheritance()} can be called to disable the inheritance
of all open handles. Call this function as soon as possible in a new
process to avoid inheriting the inherited handles even further.
The function is best effort to close the handles, it might still leave
some handles open. It should work for \code{stdin}, \code{stdout} and \code{stderr},
at least.
}
