% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphicsFuns.R
\name{plotOneBivProfile}
\alias{plotOneBivProfile}
\title{Plot bivariate profiles}
\usage{
plotOneBivProfile(allRes, allPsi, Design = NULL, threshold = NULL,
  trueEvals = NULL, main_addendum = "", ...)
}
\arguments{
\item{allRes}{list containing the list \code{res} which contains the computed minima and maxima. The object returned by the function \code{getProfileExtrema}.}

\item{allPsi}{a list containing the matrices Psi (dim \eqn{2xd}) for which to compute the profile extrema}

\item{Design}{a matrix of dimension \eqn{(2d)x numPsi} encoding the first (\code{Design[1:d,]}) and the second ((\code{Design[(d+1):(2*d),]})) axis values.}

\item{threshold}{if not \code{NULL} plots the level as a contour.}

\item{trueEvals}{if not \code{NULL} adds to each plot the data points and the observed value}

\item{main_addendum}{additional string to add to image title. Default is empty string.}

\item{...}{additional parameters to be passed to the plot function}
}
\value{
plots the 2d maps of the profile sup and inf in \code{allRes} for each Psi in \code{allPsi}. If threshold is not NULL also contours the threshold level.
}
\description{
Plots the bivariate profiles stored in \code{allRes} for each Psi in \code{allPsi}.
}
\seealso{
plotBivariateProfiles
}
\author{
Dario Azzimonti
}
