% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_progression_handler.R
\name{make_progression_handler}
\alias{make_progression_handler}
\title{Creates a Progression Calling Handler}
\usage{
make_progression_handler(
  name,
  reporter = list(),
  handler = NULL,
  enable = getOption("progressr.enable", Sys.getenv("R_PROGRESSR_ENABLE",
    interactive())),
  enable_after = getOption("progressr.enable_after",
    Sys.getenv("R_PROGRESSR_ENABLE_AFTER", 0)),
  times = getOption("progressr.times", Sys.getenv("R_PROGRESSR_TIMES", +Inf)),
  interval = getOption("progressr.interval", Sys.getenv("R_PROGRESSR_INTERVAL", 0)),
  intrusiveness = 1,
  clear = getOption("progressr.clear", Sys.getenv("R_PROGRESSR_CLEAR", TRUE)),
  target = "terminal",
  ...
)
}
\arguments{
\item{name}{(character) Name of progression handler.}

\item{reporter}{(environment) A reporter environment.}

\item{handler}{(function) Function take a \link{progression} condition
as the first argument.}

\item{enable}{(logical) If FALSE, then progress is not reported.}

\item{enable_after}{(numeric) Delay (in seconds) before progression
updates are reported.}

\item{times}{(numeric) The maximum number of times this handler
should report progression updates.
If zero, then progress is not reported.}

\item{interval}{(numeric) The minimum time (in seconds) between
successive progression updates from this handler.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{clear}{(logical) If TRUE, any output, typically visual, produced
by a reporter will be cleared/removed upon completion, if possible.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}
or not used.}
}
\value{
A function of class \code{progression_handler} that takes a
\link{progression} condition as its first and only argument.
}
\description{
A progression calling handler is a function that takes a \link[base:conditions]{base::condition}
as its first argument and that can be use together with
\code{\link[base:conditions]{base::withCallingHandlers()}}.  This function helps creating such
progression calling handler functions.
}
\details{
The inner details of progression handlers and how to use this function
are still to be documented.  Until then, see the source code of existing
handlers for how it is used, e.g. \code{progressr::handler_txtprogressbar}.
Please use with care as things might change.
}
\seealso{
\code{\link[base:conditions]{base::withCallingHandlers()}}.
}
\keyword{internal}
