% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plan-todo.R
\name{template_yaml}
\alias{template_yaml}
\title{Print YAML template to console}
\usage{
template_yaml(template = c("plan", "todo"))
}
\arguments{
\item{template}{One of \code{"plan"} or \code{"todo"} denoting template desired}
}
\value{
Prints template to console
}
\description{
Prints YAML templates for either a plan or to-do list to the console as an example
for developing your own custom plans and to-do lists. Inspired by similar \code{template_}
functions included in the \code{pkgdown} package.
}
\details{
Note that depending on the console, text editor, and settings you are using, the template may
or may not preserve the necessary whitespace shown in the output. If you copy-paste the
template for modification, ensure that it still adheres to traditional YAML indentation.
}
\examples{
template_yaml('plan')
template_yaml('todo')
}
\seealso{
Other plans and todos: \code{\link{post_plan}},
  \code{\link{post_todo}}, \code{\link{read_plan}},
  \code{\link{read_todo}}, \code{\link{report_plan}},
  \code{\link{report_todo}}
}
\concept{plans and todos}
