% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDF.R
\name{create_df}
\alias{create_df}
\title{Create a data frame of protein intensities}
\usage{
create_df(
  prot_groups,
  exp_design,
  filter_na = TRUE,
  filter_prot = TRUE,
  uniq_pep = 2,
  tech_reps = FALSE,
  zero_na = TRUE,
  log_tr = TRUE,
  base = 2
)
}
\arguments{
\item{prot_groups}{File path to proteinGroups.txt file produced by MaxQuant.}

\item{exp_design}{File path to a text file containing the experimental
design.}

\item{filter_na}{Logical. If \code{TRUE}(default), filters out empty rows and
columns from the data frame.}

\item{filter_prot}{Logical. If \code{TRUE} (default), filters out
reverse proteins, proteins only identified by site, potential contaminants,
and proteins identified with less than the minimum number of unique peptides
indicated by \code{uniq_pep}.}

\item{uniq_pep}{Numerical. The minimum number of unique peptides required to
identify a protein (default is 2). Proteins that are identified by less than
this number of unique peptides are filtered out.}

\item{tech_reps}{Logical. Indicate as \code{TRUE} if technical replicates
are present in the data. Default is \code{FALSE}.}

\item{zero_na}{Logical. If \code{TRUE} (default), zeros are considered
missing values and replaced with NAs.}

\item{log_tr}{Logical. If \code{TRUE} (default), intensity values are log
transformed to the base indicated by \code{base}.}

\item{base}{Numerical. Logarithm base. Default is 2.}
}
\value{
A \code{raw_df} object which is a data frame containing selected
proteins as rows and sample LFQ intensities as columns.
}
\description{
This function creates a data frame of label-free quantitative
(LFQ) protein intensities from MaxQuant's proteinGroups.txt file.
}
\details{
\itemize{\item This function first reads in the proteinGroups.txt file
produced by MaxQuant.
\item It then reads in the expDesign.txt file provided as
\code{exp_design} and extracts relevant information from it to add to the
data frame.
\item First, empty rows and columns are removed from the data frame.
\item Next, it filters out reverse proteins, proteins that were
only identified by site, and potential contaminants.
\item Then it removes proteins identified with less than
the number of unique peptides indicated by \code{uniq_pep} from the
data frame.
\item Next, it extracts the LFQ intensity columns and the selected protein
rows from the data  frame.
\item Converts missing values (zeros) to NAs.
\item Finally, the function log transforms the LFQ intensity values.}
}
\examples{
\donttest{
## Generate a raw_df object with default settings. No technical replicates.
raw_df <- create_df(
prot_groups = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/pg1.txt",
exp_design = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/ed1.txt"
)

## Data containing technical replicates
raw_df <- create_df(
prot_groups = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/pg2.txt",
exp_design = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/ed2.txt",
tech_reps = TRUE
)

## Alter the number of unique peptides needed to retain a protein
raw_df <- create_df(
prot_groups = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/pg1.txt",
exp_design = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/ed1.txt",
uniq_pep = 1
)
}
}
\author{
Chathurani Ranathunge
}
