% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handleNA.R
\name{impute_plot}
\alias{impute_plot}
\title{Visualize the impact of imputation}
\usage{
impute_plot(
  original,
  imputed,
  global = TRUE,
  text_size = 10,
  palette = "viridis",
  n_row,
  n_col,
  save = FALSE,
  file_path = NULL,
  file_name = "Impute_plot",
  file_type = "pdf",
  plot_width = 7,
  plot_height = 7,
  dpi = 80
)
}
\arguments{
\item{original}{A \code{raw_df} object (output of \code{\link{create_df}})
containing missing values or a \code{norm_df} object containing normalized
protein intensity data.}

\item{imputed}{An \code{imp_df} object obtained from running \code{impute_na}
on the same data frame provided as \code{original}.}

\item{global}{Logical. If \code{TRUE} ({default}), a global density plot is
produced. If \code{FALSE}, sample-wise density plots are produced.}

\item{text_size}{Text size for plot labels, axis labels etc. Default is
\code{10}.}

\item{palette}{Viridis color palette option for plots. Default is
\code{"viridis"}. See
\code{\link[viridis:viridis]{viridis}}
for available options.}

\item{n_row}{Used if \code{global = FALSE} to indicate the number of rows
to print the plots.}

\item{n_col}{Used if \code{global = FALSE} to indicate the number of
columns to print the plots.}

\item{save}{Logical. If \code{TRUE} saves a copy of the plot in the
directory provided in \code{file_path}.}

\item{file_path}{A string containing the directory path to save the file.}

\item{file_name}{File name to save the density plot/s.
Default is \code{"Impute_plot."}}

\item{file_type}{File type to save the density plot/s.
Default is \code{"pdf"}.}

\item{plot_width}{Width of the plot. Default is \code{7}.}

\item{plot_height}{Height of the plot. Default is \code{7}.}

\item{dpi}{Plot resolution. Default is \code{80}.}
}
\value{
A \code{ggplot2} plot object.
}
\description{
This function generates density plots to visualize the impact of
missing data imputation on the data.
}
\details{
\itemize{\item Given two data frames, one with missing values
and the other, an imputed data frame (\code{imp_df} object) of the same
data set, \code{impute_plot} generates global or sample-wise density plots
to visualize the impact of imputation on the data set.
\item Note, when sample-wise option is selected (\code{global = FALSE}),
\code{n_col} and \code{n_row} can be used to specify the number of columns
and rows to print the plots.
\item If you choose to specify \code{n_row} and \code{n_col}, make sure that
\code{n_row} * \code{n_col} matches the total number of samples in the
data frame.}
}
\examples{

## Generate a raw_df object with default settings. No technical replicates.
raw_df <- create_df(
  prot_groups = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/pg1.txt",
  exp_design = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/ed1.txt"
)

## Impute missing values in the data frame using the default minProb
## method.
imp_df <- impute_na(raw_df)

## Visualize the impact of missing data imputation with a global density
## plot.
impute_plot(original = raw_df, imputed = imp_df)

## Make sample-wise density plots
impute_plot(raw_df, imp_df, global = FALSE)

## Print plots in user-specified numbers of rows and columns
impute_plot(raw_df, imp_df, global = FALSE, n_col = 2, n_row = 3)

}
\author{
Chathurani Ranathunge
}
