% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StudySpecificationAccessors.R
\name{.convert_to_data.frame}
\alias{.convert_to_data.frame}
\title{(Internal) Ensures replacement column for \code{StudySpecification}
is a \code{data.frame}.}
\usage{
.convert_to_data.frame(value, specification, type)
}
\arguments{
\item{value}{A \code{vector} or \code{data.frame} containing a replacement.}

\item{specification}{A \code{StudySpecification}}

\item{type}{One of "t", "f", "u" or "b"}
}
\value{
\code{data.frame} containing named column(s)
}
\description{
Helper function for \code{StudySpecification} replacers to ensure
replacement is a properly named \code{data.frame}
}
\details{
When given a replacement set of values (e.g \code{vector} or \code{matrix}),
this ensures that the replacement is a named \code{data.frame}.

Input \code{vector}: Since it cannot be named, a vector can only be used to
replace an existing component. If the existing component has more than 1
column, uses the name of the first column.

Input \code{matrix} or \code{data.frame}: If unnamed and replacing existing
component, must have no more columns than original component. (If less
columns, uses the name of the first few columns.) If named, can replace any
number of columns.
}
\keyword{internal}
