% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StudySpecification.R
\name{specification_data_concordance}
\alias{specification_data_concordance}
\title{Check for variable agreement within units of assignment}
\usage{
specification_data_concordance(
  specification,
  data,
  by = NULL,
  warn_on_nonexistence = TRUE
)
}
\arguments{
\item{specification}{a \code{StudySpecification} object}

\item{data}{a new data set, presumably not the same used to create
\code{specification}.}

\item{by}{optional; named vector or list connecting names of variables in
\code{specification} to variables in \code{data}. Names represent
variables in \code{specification}; values represent variables in
\code{data}. Only needed if variable names differ.}

\item{warn_on_nonexistence}{default \code{TRUE}. If a variable does not
exist in \code{data}, should this be flagged? If \code{FALSE}, silently
move on if a variable doesn't exist in \code{data}.}
}
\value{
invisibly \code{TRUE} if no warnings are produced, \code{FALSE} if
any warnings are produced.
}
\description{
Useful for debugging purposes to ensure that there is
concordance between variables in the \code{StudySpecification} and data.
}
\details{
Consider the following scenario: A \code{StudySpecification} is
generated from some dataset, "data1", which includes a block variable
"b1". Within each unique unit of assignment/unitid/cluster of "data1", it
must be the case that "b1" is constant. (Otherwise the creation of the
\code{StudySpecification} will fail.)

Next, a model is fit which includes weights generated from the
\code{StudySpecification}, but on dataset "data2". In "data2", the block
variable "b1" also exists, but due to some issue with data cleaning, does
not agree with "b1" in "data1".

This could cause errors, either directly (via actual error messages) or
simply produce nonsense results. \code{\link[=specification_data_concordance]{specification_data_concordance()}} is
specificationed to help debug these scenarios by providing information on
whether variables in both the data used in the creation of
\code{specification} ("data1" in the above example) and some new dataset,
\code{data}, ("data2" in the above example) have any inconsistencies.
}
